<?php

namespace WcJUpsellator\Render;

use WcJUpsellator\Core\UpsellatorPreLoader;
use WcJUpsellator\Traits\TraitWooCommerceHelper;
use WcJUpsellator\Gift;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class ItemsList
{	

	use TraitWooCommerceHelper;
	
	public function __construct()
	{		
			/*
			/* Nothing to do
			*/ 
	}	

	public function render()
	{			
		
			$preLoader = new UpsellatorPreLoader();			
			
			$gifts = new Gift( $preLoader );
			$gifts->check();
			/*
			/* Is the cart empty?
			*/			
			if( $this->hasItems() )
			{		
					woo_j_render_view('/partials/wctimeline_items_list',  ['products' => $preLoader->cart_products, 
																			'upsells'  => new UpsellsBlock( 'modal' ),																	  
																		   ]);					

			}else{					

				woo_j_render_template('/modal/empty');	
					
			}	
			
	}
	/*
	/* 
	*/
	private function getUniqueUpsells( $upsells )
	{
		if( empty( $upsells ) ) return [];

		$read_upsells   = [];
		$unique_upsells = [];

		/*
		/* To avoid duplicates, let's first get unique upsells
		*/
		foreach( $upsells as $upsell ): 

				if( !in_array( $upsell['id'], $read_upsells ) )
				{
					$read_upsells[]   = $upsell['id'];
					$unique_upsells[] = $upsell;
				} 

		endforeach;

		return $unique_upsells;

	}
}

